// eslint-disable-next-line no-unused-vars
/* global chrome, jQuery, qtip  */

if(typeof browser === 'undefined' && typeof chrome !== 'undefined') {
    var browser = chrome;
}

let o = undefined;
let e = undefined;

let io = undefined;
let ie = undefined;

jQuery(function($){

    const getElementPosition = (element) => {
        
        let xPosition = 0;
        let yPosition = 0;
     
        while (element) {
            xPosition += (element.offsetLeft - element.scrollLeft + element.clientLeft);
            yPosition += (element.offsetTop - element.scrollTop + element.clientTop);
            element = element.offsetParent;
        }
        return {
            x: xPosition,
            y: yPosition
        };
    }
    
    const recursivelyExtractLinks = (iframe) => {

        let links = [];

        if(iframe.src && iframe.src.length > 0) {
            links.push(iframe.src); 
        }

        const iframeAnchors = $(iframe).contents().find('a');
                
        if(iframeAnchors && iframeAnchors.length)
        {
            const iframeHrefs = [];

            for(let i=0; i < iframeAnchors.length; i++)
            {
                const href = iframeAnchors[i]['href'];
                if(href && href.length > 0)
                    iframeHrefs.push(href);
            }
                            
            if(iframeHrefs.length > 0)                
                links.push.apply(links, iframeHrefs);
        }

        const innerIframes = $(iframe).contents().find('iframe');

        if(innerIframes && innerIframes.length > 0)
        {
            for(let j = 0; j < innerIframes.length; j++)
            {
                let ifr = innerIframes[j];
                links.push.apply(links, recursivelyExtractLinks(ifr));
            }            
        }
        
        return links;
    }

    $('body').on('mouseenter', 'a', function(event) {     
        
        try{

            o = this;
            e = event;

            browser.runtime.sendMessage({action:'linkDetails', href: o.href, localUrl: window.location.href});
                      
        }catch(error){
            console.log(error);
        }
        
      
    }).on('mouseleave', 'a', () => {
        $(this).qtip('destroy');
    });
    
    $('body').on('mouseenter', 'iframe', function(event) {     
        
        try{

            io = this;
            ie = event;

            let iframeHrefs = recursivelyExtractLinks(this);

            browser.runtime.sendMessage({action:'multipleLinkDetails', iframeHrefs, localUrl: window.location.href});
                                 
        }catch(error){
            console.log(error);
        }
        
      
    }).on('mouseleave', 'iframe', () => {
        $(this).qtip('destroy');
    });

    document.addEventListener('scroll', function() {
        $('.qtip').remove();        
    }, true);
   
    browser.runtime.onMessage.addListener(function(backMessage) { 
        
        if(backMessage && backMessage.tooltipMessage){
           
            if(o && o.href)
            {
                const pos = getElementPosition(io);
                const tooltipPosAt = pos && pos.y > window.outerHeight / 2 ? 'top center' : 'bottom center';               
                const tooltipPosMy = pos && pos.y > window.outerHeight / 2 ? 'bottom center' : 'top center';

                $(o).qtip({
                    style: {
                        classes: 'nrg-tooltip'                        
                    },
                    overwrite: true,
                    content: {
                        text: backMessage.tooltipMessage                     
                    },
                    show: {
                        solo: true,
                        event: 'mouseenter',
                        ready: true,
                        delay: 1000
                    },
                    hide: {
                        event: 'mouseleave'				        
                        //fixed: true
                    },
                    position: {
                        my : tooltipPosMy,                        
                        at: tooltipPosAt,
                        adjust: {
                            method: 'Shift'
                        }
                    }

                }, e);        
               
                if(backMessage.meta.unknownID) {                 
                    $(o).attr('data-click-master-unknown', o.href);                    
                    //$(o).attr('data-click-master-target', $(o).attr('target'));
                    //$(o).removeAttr('target');
                } else {
                    $(o).removeAttr('data-click-master-unknown');
                }


            }           
        }  
        else
        if(backMessage && backMessage.iframeTooltipMessage) 
        {       
            
            const pos = getElementPosition(io);
            const tooltipPosAt = pos && pos.y > window.outerHeight / 2 ? 'top center' : 'bottom center';            
            const tooltipPosMy = pos && pos.y > window.outerHeight / 2 ? 'bottom center' : 'top center';

            $(io).qtip({
                style: {
                    classes: 'nrg-tooltip'              
                },
                overwrite: true,
                content: {
                    text: backMessage.iframeTooltipMessage                   
                },
                show: {
                    solo: true,
                    event: 'mouseenter',
                    ready: true,
                    delay: 1000
                },
                hide: {
                    event: 'mouseleave'				                          
                },
                position: {
                    my : tooltipPosMy,                   
                    at: tooltipPosAt,
                    adjust: {
                        method: 'Shift'
                    }
                }

            }, ie);     
        }
        
        return true;
    });
});